#define GENETIC_MODE 0

#define true 1
#define false 0

#define MAXMOVES 32
#define INFINITY 32000

//#define MAX_BOARDS 255
#define MAX_BOARDS 1023

#ifndef __ATARI__
	#define INDEX_ERROR 0xFFFFFFFF
	typedef size_t index_type;
#else
	#if MAX_BOARDS>=255
		#define INDEX_ERROR 0xFFFF
		typedef unsigned int index_type;
	#else
		#define INDEX_ERROR 0xFF
		typedef unsigned char index_type;
	#endif
#endif

#define EMPTY  0x0
#define WHITE 0x1
#define BLACK 0x2
#define POSSIBLE_MOVE 0x3

typedef unsigned char byte;
#if !defined(__BOOL_DEFINED)
typedef unsigned char bool;
#endif
typedef unsigned int word;

#define GAME_PARTS 5
#define BEST_PLAYERS 10
#define MUTATED_TIMES (BEST_PLAYERS-1)
#define MAX_PLAYERS ((BEST_PLAYERS)+(BEST_PLAYERS*MUTATED_TIMES))

enum EWeight {
	e_piece_differential_weight,
	e_mobility_weight,
	e_edges_weight,
	e_corners_weight,
	e_x_weight,
	e_c_weight,
	e_stable_disc_weight,
	//	e_potential_mobility_weight,
	e_max_weight
};
